/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.services.RepositoryService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.net.URL;

public abstract class AbstractRepositoryChangeState
implements Action {
    @Override
    public void handleAction(Object context) throws ApplicationException {
        if (context == null) {
            return;
        }
        I18N i18n = Application.getI18n();
        String s = context.toString();
        if ("https://www.willuhn.de/products/jameica/updates".equalsIgnoreCase(s)) {
            throw new ApplicationException(i18n.tr("Status des System-Repository darf nicht ge\u00e4ndert werden"));
        }
        URL url = null;
        try {
            url = new URL(s);
        }
        catch (Exception e) {
            Logger.error((String)("invalid url: " + context), (Throwable)e);
            throw new ApplicationException(i18n.tr("Keine g\u00fcltige Repository-URL angegeben"));
        }
        RepositoryService service = (RepositoryService)Application.getBootLoader().getBootable(RepositoryService.class);
        service.setEnabled(url, this.getEnabled());
    }

    abstract boolean getEnabled();
}

